part of 'list_view.dart';

class ListItem extends StatelessWidget {
  final OrderData orderData;
  final VoidCallback onSelect;
  final bool isSelect;
  final MainNotifier mainNotifier;

  const ListItem({
    super.key,
    required this.orderData,
    required this.onSelect,
    required this.isSelect,
    required this.mainNotifier,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        InkWell(
          onTap: () => mainNotifier.setOrder(orderData),
          child: AnimatedContainer(
            duration: const Duration(milliseconds: 500),
            color: isSelect ? Style.mainBack : Style.white,
            padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 18),
            child: Row(
              children: [
                CustomCheckbox(isActive: isSelect, onTap: onSelect),
                8.horizontalSpace,
                SizedBox(
                  width: 48,
                  child: Text(
                    "${orderData.id ?? "--"}",
                    style: Style.interRegular(
                      size: 16,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                8.horizontalSpace,
                SizedBox(
                  width: 140.w,
                  child: Text(
                    orderData.user?.firstname ?? "--",
                    maxLines: 1,
                    style: Style.interRegular(
                      size: 14,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                8.horizontalSpace,
                SizedBox(
                  width: 120.w,
                  child: Row(
                    children: [
                      Container(
                        padding: const EdgeInsets.symmetric(
                            horizontal: 10, vertical: 4),
                        decoration: BoxDecoration(
                            color: AppHelpers.getStatusColor(orderData.status)
                                .withOpacity(0.25),
                            borderRadius: BorderRadius.circular(100)),
                        child: Text(
                          AppHelpers.getTranslation(orderData.status ?? "--"),
                          style: Style.interRegular(
                            size: 14,
                            color: AppHelpers.getStatusColor(orderData.status),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                8.horizontalSpace,
                SizedBox(
                  width: 120.w,
                  child: Text(
                    orderData.deliveryman?.firstname ?? "--",
                    maxLines: 1,
                    style: Style.interRegular(
                      size: 16,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                8.horizontalSpace,
                SizedBox(
                  width: 100.w,
                  child: Text(
                    AppHelpers.numberFormat(
                      number: orderData.totalPrice,
                      symbol: orderData.currency?.symbol,
                      isOrder: true,
                    ),
                    style: Style.interRegular(
                      size: 14,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                8.horizontalSpace,
                SizedBox(
                  width: 120.w,
                  child: Text(
                    TimeService.dateFormatMDHm(
                        orderData.createdAt ?? DateTime.now()),
                    style: Style.interRegular(
                      size: 14,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                8.horizontalSpace,
                Expanded(
                  child: Text(
                    TimeService.dateFormat(orderData.deliveryDate),
                    style: Style.interRegular(
                      size: 14,
                      color: Style.brandTitleDivider,
                    ),
                  ),
                ),
                CustomPopup(
                  isLocation: orderData.deliveryType == TrKeys.delivery,
                  orderData: orderData,
                ),
              ],
            ),
          ),
        ),
        const Divider(height: 2),
      ],
    );
  }
}
